/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.ntfy;

import com.ibm.hwmca.base.ntfy.NotificationConstants;
import com.ibm.hwmca.base.ntfy.NotificationMessageRes;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.ColumnDescriptor;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.ItemDescriptor;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.TaskMessage;
import java.util.HashMap;
import java.util.Map;

public class EditSourcePanelBean
extends PanelBean
implements NotificationConstants {
    private static final String TRACE_MASKT = "XNTYESNT";
    private static final String TRACE_MASKF = "XNTYESNF";
    private static final String TRACE_MASKD = "XNTYESND";
    private String m_sSourceName;
    private String m_sDescription;
    private boolean m_bEnabledCheckbox;
    private String m_sObjectName;
    private transient ItemDescriptor[] m_idFilterTable;
    private transient ColumnDescriptor[] m_cdFilterTableStructure;
    private int[] m_iFilterTableSelection;
    private Map data;
    public static final String DATA_MAP_SOURCE_NAME = "DataMapSourceName";
    public static final String DATA_MAP_DESCRIPTION = "DataMapDescription";
    public static final String DATA_MAP_ENABLED_CHECKBOX = "DataMapEnabledCheckbox";
    public static final String DATA_MAP_FILTER_NAME = "DataMapFilterName";
    public static final String DATA_MAP_OBJECT_NAME = "DataMapObjectName";
    public static final String TASKLET_SOURCE_DATA_MAP = "TaskletSourceDataMap";
    public static final String SOURCE_NAME = "SourceName";
    public static final String OBJECT_NAME = "ObjectName";
    public static final String DESCRIPTION = "Description";
    public static final String FILTER_TABLE = "FilterTable";

    public void panelAction(TaskActionEvent event) {
        Trace.trace(TRACE_MASKT, "-> panelAction()");
        String command = event.getActionCommand();
        if (command == null || command.equals("CANCEL")) {
            command = this.getMountPrefix() + "CancelButton";
        }
        this.userTaskManager.storeAllElements();
        this.userTaskManager.storeElement(this.getMountPrefix() + DESCRIPTION);
        PanelTaskletRequest request = new PanelTaskletRequest(this.getClass().getName() + this.getMountPrefix());
        request.setData("CommandSource", "EditSourcePanel");
        this.data.put(DATA_MAP_SOURCE_NAME, this.m_sSourceName);
        this.data.put(DATA_MAP_DESCRIPTION, this.m_sDescription);
        this.data.put(DATA_MAP_ENABLED_CHECKBOX, new Boolean(this.m_bEnabledCheckbox));
        if (command.equals(this.getMountPrefix() + "OKButton")) {
            request.setData("CommandName", "OKButton");
            request.setData(TASKLET_SOURCE_DATA_MAP, this.data);
        } else if (command.equals(this.getMountPrefix() + "CancelButton")) {
            request.setData("CommandName", "CancelButton");
        } else if (command.equals(this.getMountPrefix() + "FilterButton")) {
            request.setData("CommandName", "FilterButton");
            request.setData(DATA_MAP_FILTER_NAME, this.data.get(DATA_MAP_FILTER_NAME));
        } else if (command.equals(this.getMountPrefix() + "ObjectsButton")) {
            request.setData("CommandName", "ObjectsButton");
            request.setData(DATA_MAP_OBJECT_NAME, this.data.get(DATA_MAP_OBJECT_NAME));
        }
        if ((request.getData("CommandName").equals("OKButton") || request.getData("CommandName").equals("ApplyButton")) && (this.m_sSourceName == null || this.m_sSourceName.trim().equals(""))) {
            TaskMessage tm = new TaskMessage(this.userTaskManager, new NotificationMessageRes().getString("ntfy.error.blankname"), 1);
            tm.invoke();
            this.userTaskManager.setValue(this.getMountPrefix() + SOURCE_NAME, "");
            this.m_sSourceName = "";
        } else {
            this.postTaskletRequest(request);
        }
        Trace.trace(TRACE_MASKT, "<- panelAction()");
    }

    public void update(Object newData) {
        if (newData instanceof Map) {
            Map map = (Map)newData;
            String commandName = (String)map.get("CommandName");
            if (commandName == null) {
                commandName = "";
            }
            if (commandName.equals("ObjectsButton")) {
                LocalizableText selectedObject = (LocalizableText)map.get("ObjectsButton");
                if (selectedObject == null) {
                    this.userTaskManager.setValue(this.getMountPrefix() + OBJECT_NAME, "");
                } else {
                    this.userTaskManager.setValue(this.getMountPrefix() + OBJECT_NAME, selectedObject.toString());
                }
                this.data.put(DATA_MAP_OBJECT_NAME, selectedObject);
            } else if (commandName.equals("FilterButton")) {
                String[] newFilters = (String[])map.get("FilterButton");
                this.data.put(DATA_MAP_FILTER_NAME, newFilters);
                this.userTaskManager.refreshAllElements();
            }
        }
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> save()");
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> prepare()");
        if (!this.m_sSourceName.equals("")) {
            this.userTaskManager.setReadOnly(this.getMountPrefix() + SOURCE_NAME, true);
        }
        this.userTaskManager.setReadOnly(this.getMountPrefix() + OBJECT_NAME, true);
        Trace.trace(TRACE_MASKT, "<- prepare()");
    }

    public void load() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        this.m_sSourceName = (String)this.data.get(DATA_MAP_SOURCE_NAME);
        this.m_sDescription = (String)this.data.get(DATA_MAP_DESCRIPTION);
        Boolean b = (Boolean)this.data.get(DATA_MAP_ENABLED_CHECKBOX);
        LocalizableText lt = (LocalizableText)this.data.get(DATA_MAP_OBJECT_NAME);
        if (this.m_sSourceName == null) {
            this.m_sSourceName = "";
        }
        if (this.m_sDescription == null) {
            this.m_sDescription = "";
        }
        this.m_bEnabledCheckbox = b == null ? true : b;
        this.m_sObjectName = lt == null ? "" : lt.toString();
        this.m_idFilterTable = new ItemDescriptor[0];
        this.m_cdFilterTableStructure = new ColumnDescriptor[0];
        this.m_iFilterTableSelection = new int[0];
        String[] filters = (String[])this.data.get(DATA_MAP_FILTER_NAME);
        if (filters == null) {
            this.data.put(DATA_MAP_FILTER_NAME, new String[0]);
        }
    }

    public void setData(Map data) {
        this.data = data;
    }

    public int getFilterTableRowCount() {
        String[] filters = (String[])this.data.get(DATA_MAP_FILTER_NAME);
        return filters.length;
    }

    public ItemDescriptor[] getFilterTableRowAt(int index) {
        String[] filters = (String[])this.data.get(DATA_MAP_FILTER_NAME);
        return new ItemDescriptor[]{new ItemDescriptor(this.getMountPrefix() + FILTER_TABLE + index, filters[index])};
    }

    public String getSourceName() {
        return this.m_sSourceName;
    }

    public void setSourceName(String s) throws IllegalUserDataException {
        this.m_sSourceName = s;
    }

    public String getDescription() {
        return this.m_sDescription;
    }

    public void setDescription(String s) throws IllegalUserDataException {
        this.m_sDescription = s;
    }

    public boolean isEnabledCheckbox() {
        return this.m_bEnabledCheckbox;
    }

    public void setEnabledCheckbox(boolean b) throws IllegalUserDataException {
        this.m_bEnabledCheckbox = b;
    }

    public ColumnDescriptor[] getFilterTableRowStructure() {
        return this.m_cdFilterTableStructure;
    }

    public int getFilterTableRowStatus() {
        return 3;
    }

    public void setFilterTableRowAt(int index, ItemDescriptor[] items) throws IllegalUserDataException {
        this.m_idFilterTable = items;
    }

    public int[] getFilterTableSelection() {
        return this.m_iFilterTableSelection;
    }

    public void setFilterTableSelection(int[] selected) throws IllegalUserDataException {
        this.m_iFilterTableSelection = selected;
    }

    public String getObjectName() {
        return this.m_sObjectName;
    }

    public void setObjectName(String s) throws IllegalUserDataException {
        this.m_sObjectName = s;
    }
}

